# Cuadro XI.3
# Regresin no lineal

########################################################
# Seccin modificable por el usuario
########################################################

#Lectura archivo de datos csv
datos<-read.csv2("Cuadro XI.3.V.csv",enc="latin1")

#Seleccin de variables

#Variable dependiente
varRespuesta<-"Tasa.Crecimiento"

#Variable independiente
varExplicativa<-"Conc.Fosfato"

#Frmula del modelo. "valorex" es el nombre que debe llevar la vairable explicativa
formula<-paste("umax*(1-exp(-b*(valorex-Kmin)))")

#Valores iniciales de parmetros
#parametros<-list(umax=0.4,b=1,Kmin=0.05)
parametros<-NULL

#Variables de seleccin.
varSeleccion1<-list(c("Especie","A. tamarense"))
#varSeleccion1<-NULL

#varSeleccion2<-list(c("","",""))
varSeleccion2<-NULL

#Nombre del archivo en que se guardan los residuos
CSVr<-"Salida Cuadro XI.3.1.csv"

#Nombre del archivo en que se guardan los datos de la ecuacin
CSVc<-"Salida Cuadro XI.3.2.csv"

#Nombre del archivo de salida
ArchivodeSalida<-"Salida Cuadro XI.3.txt"

########################################################
# Seccin que realiza el procedimiento
########################################################

#Selecciones
if (length(varSeleccion1)!=0){
 w1<-data.frame(row.names=1:dim(datos)[1])
 varBin1<-as.character()
 for (i in 1:length(varSeleccion1)){
   nom1<-varSeleccion1[[i]][1]
   x1<-factor(datos[,nom1])
   if (length(varSeleccion1[[i]])>1){
      sufijo1<-paste(varSeleccion1[[i]][2:3],collapse="_")
      nom1<-paste(nom1,".",sufijo1,sep="")
      x11<-factor(ifelse(x1 %in% varSeleccion1[[i]][2:3],as.character(x1),NA))
      x11<-data.frame(factor(x11))
   }else{
      x11<-x1
      x11<-data.frame(x1)
   }
   names(x11)<-nom1
   varBin1<-c(varBin1,nom1)
   w1<-data.frame(w1,x11)
 }
}

if (length(varSeleccion2)!=0){
 w2<-data.frame(row.names=1:dim(datos)[1])
 varBin2<-as.character()
 for (i in 1:length(varSeleccion2)){
   nom2<-varSeleccion2[[i]][1]
   x2<-factor(datos[,nom2])
   if (length(varSeleccion2[[i]])>1){
      sufijo2<-paste(varSeleccion2[[i]][2:3],collapse="_")
      nom2<-paste(nom2,".",sufijo2,sep="")
      x12<-factor(ifelse(x2 %in% varSeleccion2[[i]][2:3],as.character(x2),NA))
      x12<-data.frame(factor(x12))
   }else{
      x12<-x2
      x12<-data.frame(x2)
   }
   names(x12)<-nom2
   varBin2<-c(varBin2,nom2)
   w2<-data.frame(w2,x12)
 }
}

if ((length(varSeleccion1)!=0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w1,w2)
if ((length(varSeleccion1)!=0)&(length(varSeleccion2)==0)) seleccion<-data.frame(w1)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)!=0)) seleccion<-data.frame(w2)
if ((length(varSeleccion1)==0)&(length(varSeleccion2)==0)) seleccion<-NULL

#Conjunto de datos
if (length(seleccion)==0) datos2<-data.frame(datos)
if (length(seleccion)!=0) datos2<-data.frame(seleccion,datos)
datos<-na.omit(datos2)
valores<-datos[,varRespuesta]
valorex<-datos[,varExplicativa]
datos1<-data.frame(valores,valorex)

#Modelo de regresin no lineal
expresion<-as.formula(paste("valores~",formula,sep=""))
if(length(parametros)!=0)modelo<-nls(expresion,data=datos1,start=parametros)
if(length(parametros)==0)modelo<-nls(expresion,data=datos1)
Resumenmodelo<-summary(modelo)

#Clculo R^2
TSS<-(nrow(datos1)-1)*var(valores)
RSS<-sum((residuals(modelo))^2)
Rsqr<-1 - RSS/TSS
R2<-c("Valor.de.R^2:"=Rsqr)

#Grfica
plot(valorex,valores)
xlinea<-seq((min(valorex)-1),(max(valorex)+1),0.1)
ylinea<-predict(modelo,list(valorex=xlinea))
lines(xlinea,ylinea)

########################################################
# Seccin que muestra los resultados
########################################################

#Genera archivo csv con resduos
write.csv2(residuals(modelo),file=CSVr)

#Genera archivo csv con datos de la ecuacin
write.csv2(coef(modelo),file=CSVc)

#Imprime resultados en archivo txt
if(!is.null(ArchivodeSalida)){
 sink(ArchivodeSalida)
 print(Resumenmodelo)
 print(R2)
 sink()
}

